/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pa.sql.ExposedField;
import filenet.pa.sql.PAPEPartition;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskFolderNode;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.pa.PAActionCommand;
import filenet.vw.apps.taskman.pa.PADataFieldExportWizard;
import filenet.vw.apps.taskman.pa.PADataFieldImportWizard;
import filenet.vw.apps.taskman.pa.PADataFieldNode;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PADataFieldsTableModel;
import filenet.vw.apps.taskman.pa.PADataFieldsTablePanel;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.panonrmi.IPANonRMI;
import filenet.vw.apps.taskman.pa.peconnection.IPEConnection;
import filenet.vw.apps.taskman.pa.peconnection.PEConnectionFactory;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogField;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogFields;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PADataFieldsNode
extends VWTaskFolderNode {
    private PANode m_parent = null;
    private PADataFieldsTablePanel m_tablePanel = null;
    private boolean m_bShowSystemFields = true;
    IPEConnection m_peConnection = null;
    private ConnectionPoint m_connectionPointObj = null;
    private String m_connectionPoint = null;
    private static final String XML_ELEMENT_NAME = "DataFields";

    public PADataFieldsNode(PANode parent) throws Exception {
        super(VWResource.DataFields);
        this.m_parent = parent;
        this.fromXML();
        this.m_tablePanel = new PADataFieldsTablePanel(new PADataFieldsTableModel(this), VWResource.DataFields, this);
        VWTaskUtil.updateComponentOrientation(this.m_tablePanel);
        this.getContentPane().setTablePanel(this.m_tablePanel);
        this.m_peConnection = PEConnectionFactory.getPEConnection(this.m_parent);
    }

    public void refresh() {
        try {
            this.refreshDataFields();
            this.m_tablePanel.refresh();
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "pa_data_fields.htm");
    }

    public PEExposedLogFields getEventLogFields() throws Exception {
        if (!this.isConnected()) {
            return new PEExposedLogFields();
        }
        VWDebug.logInfo("Entering getEventLogFields()");
        VWDebug.logInfo("PE Connection region: " + this.m_peConnection.getIsolatedRegion());
        IPANonRMI paNonRMI = this.m_parent.getPANonRMI();
        HashMap map = new HashMap();
        if (paNonRMI.isPAPEPartitionEnabled()) {
            PAPEPartition[] partitions = paNonRMI.getPAPEPartitions();
            for (int i = 0; i < partitions.length; ++i) {
                PAPEPartition p = partitions[i];
                if (p.getRegionId() != this.m_peConnection.getIsolatedRegion()) {
                    VWDebug.logInfo("Ignoring partition from region: " + p.getRegionId());
                    continue;
                }
                if (p.getEventLog() == null) {
                    VWDebug.logInfo("Found null event log partition.");
                    break;
                }
                String viewName = p.getEventLog();
                String logName = viewName.substring(viewName.indexOf("_") + 1);
                map.put(logName, null);
                VWDebug.logInfo("Adding partition event log: " + logName);
            }
        }
        PEExposedLogFields fields = null;
        fields = map.size() > 0 ? this.m_peConnection.getLogFields(map) : this.m_peConnection.getLogFields(null);
        VWDebug.logInfo("Here are the PE fields found for the event log: ");
        PEExposedLogField[] peFields = fields.getFields(true);
        for (int i = 0; i < peFields.length; ++i) {
            VWDebug.logInfo(peFields[i].getName());
        }
        return fields;
    }

    protected int getConnectedIsolatedRegion() {
        return this.m_peConnection.getIsolatedRegion();
    }

    protected String getConnectedServiceName() {
        return this.isConnected() ? this.m_connectionPointObj.DNSName : "";
    }

    protected String getConnectedConnectionPoint() {
        return this.isConnected() ? this.m_connectionPoint : null;
    }

    protected boolean isConnected() {
        return this.m_peConnection != null && this.m_peConnection.isConnected();
    }

    protected boolean isNameUnique(String name) {
        return this.findChildNode(name) == null;
    }

    protected boolean getShowSystemFields() {
        return this.m_bShowSystemFields;
    }

    protected void setShowSystemFields(boolean showSystemFields) {
        this.m_bShowSystemFields = showSystemFields;
    }

    protected Integer[] getIsolatedRegions() {
        HashMap regions = new HashMap();
        Object[] regionArr = regions.values().toArray(new Integer[regions.size()]);
        Arrays.sort(regionArr);
        return regionArr;
    }

    protected void disconnect() {
        this.m_peConnection.disconnect();
        this.m_tablePanel.refresh();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String BASE_INDENT = "\t\t";
        String ATTRIB_INDENT = BASE_INDENT + "\t";
        theBuffer.append(BASE_INDENT + "<" + XML_ELEMENT_NAME + "\n");
        theBuffer.append(ATTRIB_INDENT + "ConnectionPoint=\"" + VWTaskXMLHandler.toXMLString(this.m_connectionPoint) + "\"/>\n");
    }

    private void fromXML() {
        try {
            Node node = VWTaskXMLHandler.getNodeNamed(this.m_parent.getXMLNode(), XML_ELEMENT_NAME);
            if (node == null || node.getNodeType() != 1) {
                return;
            }
            Element ele = (Element)node;
            if (ele.getAttributeNode("ConnectionPoint") != null) {
                this.m_connectionPoint = ele.getAttribute("ConnectionPoint");
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Error reading DataFields xml.");
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, PAActionCommand.NEW) == 0) {
                this.newDataField();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.HELP) == 0) {
                this.displayHelp();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.EXPORT_DATAFIELDS) == 0) {
                this.exportDataFields();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.IMPORT_DATAFIELDS) == 0) {
                this.importDataFields();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{PAActionCommand.NEW, "Add Separator", PAActionCommand.EXPORT_DATAFIELDS, PAActionCommand.IMPORT_DATAFIELDS, "Add Separator", PAActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, PAActionCommand.NEW) == 0) {
            return !this.m_parent.isStarted();
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.EXPORT_DATAFIELDS) == 0) {
            return this.getChildCount() > 0;
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.IMPORT_DATAFIELDS) == 0) {
            return !this.m_parent.isStarted();
        }
        return true;
    }

    private void refreshDataFields() throws Exception {
        ExposedField[] fields = this.m_parent.getExposedDataFields();
        if (fields != null) {
            PADataFieldNode node;
            int i;
            VWTaskBaseNode[] childNodes = this.getChildNodes();
            if (childNodes != null) {
                for (i = 0; i < childNodes.length; ++i) {
                    node = (PADataFieldNode)childNodes[i];
                    boolean found = false;
                    for (int j = 0; j < fields.length; ++j) {
                        if (!fields[j].getUniqueName().equals(node.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    node.delete();
                }
            }
            for (i = 0; i < fields.length; ++i) {
                node = (PADataFieldNode)this.findChildNode(fields[i].getUniqueName());
                if (node == null) {
                    this.add(new PADataFieldNode(this, fields[i]), 1);
                    continue;
                }
                node.setExposedField(fields[i]);
                node.refresh();
            }
        } else {
            this.removeAllChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newDataField() throws Exception {
        try {
            PADataFieldWizard wizard = new PADataFieldWizard(this);
            wizard.setVisible(true);
        }
        finally {
            this.m_tablePanel.refresh();
        }
    }

    protected PANode getPANode() {
        return this.m_parent;
    }

    protected void disposeDataField(String uniqueName) throws Exception {
        this.m_parent.disposeDataField(uniqueName);
    }

    private void exportDataFields() {
        PADataFieldExportWizard wizard = new PADataFieldExportWizard(this);
        wizard.setVisible(true);
    }

    private void importDataFields() {
        PADataFieldImportWizard wizard = new PADataFieldImportWizard(this);
        wizard.setVisible(true);
    }
}

